import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 8))

# Define colors for ingredients
ingredient1_color = 'red'
ingredient2_color = 'blue'

# Define positions and sizes
shot_width, shot_height = 1, 1
shaker_radius = 0.75
dispenser_width, dispenser_height = 1.5, 0.5
hand_width, hand_height = 0.5, 1

# Draw shots
shots = [
    {'pos': (1, 5), 'label': 'shot_1', 'status': 'clean, empty'},
    {'pos': (4, 5), 'label': 'shot_2', 'status': 'clean, empty'},
    {'pos': (7, 5), 'label': 'shot_3', 'status': 'clean, empty'}
]

for shot in shots:
    ax.add_patch(patches.Rectangle(shot['pos'], shot_width, shot_height, edgecolor='black', facecolor='white'))
    ax.text(shot['pos'][0] + shot_width / 2, shot['pos'][1] + shot_height / 2, f"{shot['label']}\n{shot['status']}",
            ha='center', va='center', fontsize=8, color='black')

# Draw shaker
shaker_pos = (4.5, 2)
ax.add_patch(patches.Circle(shaker_pos, shaker_radius, edgecolor='black', facecolor='white'))
ax.text(shaker_pos[0], shaker_pos[1], 'shaker_1\nclean, empty', ha='center', va='center', fontsize=8, color='black')

# Draw dispensers
dispensers = [
    {'pos': (1, 7), 'label': 'dispenser_1', 'color': ingredient1_color},
    {'pos': (7, 7), 'label': 'dispenser_2', 'color': ingredient2_color}
]

for dispenser in dispensers:
    ax.add_patch(patches.Rectangle(dispenser['pos'], dispenser_width, dispenser_height, edgecolor='black', facecolor=dispenser['color']))
    ax.text(dispenser['pos'][0] + dispenser_width / 2, dispenser['pos'][1] + dispenser_height / 2, dispenser['label'],
            ha='center', va='center', fontsize=8, color='black')

# Draw hands
hands = [
    {'pos': (0, 3), 'label': 'left_hand', 'status': 'empty'},
    {'pos': (9, 3), 'label': 'right_hand', 'status': 'empty'}
]

for hand in hands:
    ax.add_patch(patches.Rectangle(hand['pos'], hand_width, hand_height, edgecolor='black', facecolor='white'))
    ax.text(hand['pos'][0] + hand_width / 2, hand['pos'][1] + hand_height / 2, f"{hand['label']}\n{hand['status']}",
            ha='center', va='center', fontsize=8, color='black')

# Legend
legend_elements = [
    patches.Patch(facecolor=ingredient1_color, edgecolor='black', label='ingredient1 (red)'),
    patches.Patch(facecolor=ingredient2_color, edgecolor='black', label='ingredient2 (blue)')
]
ax.legend(handles=legend_elements, loc='upper right')

# Set limits and hide axes
ax.set_xlim(0, 10)
ax.set_ylim(0, 8)
ax.axis('off')

# Save the figure
plt.savefig('barman/one_shot/ini_diagram_code/attempts/attempt_18.png', bbox_inches='tight')
plt.show()